<?php 
$projects = $seed['projects'] ?? [];
$jobs     = $seed['jobs'] ?? [];
if (!can_view_all()) {
  $team = user_team();
  $allowed = array_column(array_values(array_filter($projects, fn($p)=>($p['team']??'')===$team)), 'id');
  $jobs = array_values(array_filter($jobs, fn($j)=> in_array($j['project_id'], $allowed, true)));
}
?>
<section class="calwrap light">
  <!-- Top Bar -->
  <div class="cal-topbar" role="toolbar" aria-label="Calendar toolbar">
    <div class="left">
      <div class="today-label" id="topToday"></div>
      <button class="btn tiny" id="btnToday" aria-label="Jump to today">Today</button>
    </div>
    <div class="right">
      <button class="btn ghost" id="btnCreate">Create Schedule</button>
      <button class="btn primary" id="btnAdd">+ Add Event/Task</button>
      <div class="view-switch" role="group" aria-label="View switch">
        <button class="seg active" data-view="month" id="btnMonth">Month View ▾</button>
      </div>
    </div>
  </div>

  <div class="cal-body">
    <!-- Sidebar -->
    <aside class="side">
      <!-- Mini calendar -->
      <div class="mini card">
        <div class="mini-head">
          <button class="nav" id="miniPrev" aria-label="Previous month">‹</button>
          <div class="mini-title" id="miniTitle"></div>
          <button class="nav" id="miniNext" aria-label="Next month">›</button>
        </div>
        <div class="mini-grid" id="miniGrid" aria-label="Mini calendar"></div>
      </div>

      <!-- Legend -->
      <div class="legend card">
        <div class="lg-title">Status Legend</div>
        <div class="lg-list">
          <span class="dot completed"></span> Completed
          <span class="dot inprogress"></span> In Progress
          <span class="dot planned"></span> Planned
          <span class="dot onhold"></span> On Hold
          <span class="dot blocked"></span> Blocked
          <span class="dot other"></span> Other
        </div>
      </div>

      <!-- Filters -->
      <div class="filters card">
        <div class="f-head">SEARCH FILTERS</div>
        <label class="switch">
          <input type="checkbox" id="fOnline"><span></span>
          <em>Online events only</em>
        </label>
        <label class="switch">
          <input type="checkbox" id="fRepeat"><span></span>
          <em>Repeated events</em>
        </label>

        <div class="field">
          <div class="label">Hosted by</div>
          <select id="fHost">
            <option value="">Anyone</option>
            <option>Production</option>
            <option>Engineering</option>
            <option>QA</option>
            <option>Warehouse</option>
          </select>
        </div>
        <div class="field">
          <div class="label">Guest ID</div>
          <input id="fGuest" placeholder="Optional">
        </div>
        <div class="field">
          <div class="label">Location</div>
          <input id="fLoc" placeholder="Optional">
        </div>
      </div>
    </aside>

    <!-- Main Month View -->
    <main class="month">
      <div class="m-head card">
        <button class="nav" id="mainPrev" aria-label="Previous month">‹</button>
        <div class="title" id="mainTitle">September 2025</div>
        <button class="nav" id="mainNext" aria-label="Next month">›</button>
      </div>

      <div class="grid card">
        <div class="dow">Sun</div><div class="dow">Mon</div><div class="dow">Tue</div>
        <div class="dow">Wed</div><div class="dow">Thu</div><div class="dow">Fri</div><div class="dow">Sat</div>
        <div id="monthGrid" class="cells" aria-label="Month grid"></div>
      </div>
    </main>
  </div>
</section>

<!-- Drawer (Event/Day details) -->
<div id="drawer" class="drawer" aria-hidden="true">
  <div class="drawer-panel" role="dialog" aria-labelledby="drawerTitle">
    <div class="drawer-head">
      <div>
        <div id="drawerTitle" class="drawer-title">Details</div>
        <div id="drawerSub" class="drawer-sub"></div>
      </div>
      <button class="btn ghost" id="drawerClose" aria-label="Close">✕</button>
    </div>
    <div class="drawer-body" id="drawerBody"></div>
    <div class="drawer-foot">
      <button class="btn" id="drawerClose2">Close</button>
      <button class="btn primary">Open</button>
    </div>
  </div>
</div>

<script>
(function(){
  // ===== Data =====
  const JOBS = <?= json_encode($jobs, JSON_UNESCAPED_UNICODE) ?>;

  // map status -> สี
  const statusColor = {
    'completed': '#16a34a',
    'done':      '#16a34a',
    'in progress':'#2563eb',
    'planned':   '#f59e0b',
    'on hold':   '#6b7280',
    'blocked':   '#ef4444',
    'other':     '#8b5cf6'
  };

  // ===== Utilities =====
  const pad = n => String(n).padStart(2,'0');
  const toKey = d => `${d.getFullYear()}-${pad(d.getMonth()+1)}-${pad(d.getDate())}`;
  const parseStatus = s => (String(s||'').toLowerCase());
  const guessColor = s => {
    const k = parseStatus(s);
    if (k in statusColor) return statusColor[k];
    if (k.includes('progress')) return statusColor['in progress'];
    if (k.includes('plan'))     return statusColor['planned'];
    if (k.includes('hold'))     return statusColor['on hold'];
    if (k.includes('done')||k.includes('complete')) return statusColor['done'];
    if (k.includes('block'))    return statusColor['blocked'];
    return statusColor['other'];
  };

  // group jobs by date
  const jobsByDate = {};
  JOBS.forEach(j=>{
    const key = (j.date||'').slice(0,10);
    if(!jobsByDate[key]) jobsByDate[key] = [];
    jobsByDate[key].push(j);
  });

  // ===== Elements =====
  const topToday  = document.getElementById('topToday');
  const btnToday  = document.getElementById('btnToday');

  const miniTitle = document.getElementById('miniTitle');
  const miniGrid  = document.getElementById('miniGrid');
  const miniPrev  = document.getElementById('miniPrev');
  const miniNext  = document.getElementById('miniNext');

  const mainTitle = document.getElementById('mainTitle');
  const monthGrid = document.getElementById('monthGrid');
  const mainPrev  = document.getElementById('mainPrev');
  const mainNext  = document.getElementById('mainNext');

  // Drawer
  const drawer = document.getElementById('drawer');
  const drawerTitle = document.getElementById('drawerTitle');
  const drawerSub   = document.getElementById('drawerSub');
  const drawerBody  = document.getElementById('drawerBody');
  const closeBtns   = [document.getElementById('drawerClose'), document.getElementById('drawerClose2')];

  const openDrawer = (title, subtitle, html) => {
    drawerTitle.textContent = title || 'Details';
    drawerSub.textContent   = subtitle || '';
    drawerBody.innerHTML    = html || '';
    drawer.classList.add('open');
    drawer.setAttribute('aria-hidden', 'false');
  };
  const closeDrawer = () => {
    drawer.classList.remove('open');
    drawer.setAttribute('aria-hidden', 'true');
  };
  closeBtns.forEach(b=> b.addEventListener('click', closeDrawer));
  drawer.addEventListener('click', e=> { if(e.target===drawer) closeDrawer(); });

  // ===== State =====
  let viewDate = new Date();

  // ===== Renderers =====
  function renderTop(){
    const now = new Date();
    topToday.textContent = now.toLocaleDateString(undefined, {
      weekday:'long', day:'2-digit', month:'short', year:'numeric'
    });
  }
  const monthLabel = d => d.toLocaleDateString(undefined, { month:'long', year:'numeric' });
  const plusMonth = (dt, n) => new Date(dt.getFullYear(), dt.getMonth()+n, 1);

  function renderMini(d){
    miniTitle.textContent = monthLabel(d);
    miniGrid.innerHTML = '';

    // header
    ['S','M','T','W','T','F','S'].forEach(s=>{
      const h = document.createElement('div');
      h.className = 'mini-dow';
      h.textContent = s;
      miniGrid.appendChild(h);
    });

    const first = new Date(d.getFullYear(), d.getMonth(), 1);
    const start = new Date(first);
    start.setDate(first.getDate() - first.getDay()); // Sunday

    for(let i=0; i<42; i++){
      const cur = new Date(start); cur.setDate(start.getDate()+i);
      const key = toKey(cur);

      const cell = document.createElement('button');
      cell.className = 'mini-cell'+(cur.getMonth()!==d.getMonth()?' dim':'');
      cell.dataset.date = key;

      const dot = document.createElement('span'); dot.className = 'dot';
      const txt = document.createElement('span'); txt.textContent = cur.getDate();
      cell.append(dot, txt);

      const todayKey = toKey(new Date());
      if (key===todayKey) cell.classList.add('today');
      if ((jobsByDate[key]||[]).length) cell.classList.add('has');

      cell.addEventListener('click', ()=>{
        viewDate = new Date(cur);
        renderMini(viewDate); renderMain(viewDate);
      });
      miniGrid.appendChild(cell);
    }
  }

  function renderMain(d){
    mainTitle.textContent = monthLabel(d);
    monthGrid.innerHTML = '';

    const first = new Date(d.getFullYear(), d.getMonth(), 1);
    const start = new Date(first);
    start.setDate(first.getDate() - first.getDay()); // Sunday
    const todayKey = toKey(new Date());

    for(let i=0;i<42;i++){
      const cur = new Date(start); cur.setDate(start.getDate()+i);
      const key = toKey(cur);

      const cell = document.createElement('div');
      cell.className = 'day'+(cur.getMonth()!==d.getMonth()?' muted':'')+(cur.getDay()===0||cur.getDay()===6?' weekend':'');

      // header number + count badge
      const hd = document.createElement('div');
      hd.className = 'dnum';
      hd.textContent = cur.getDate();
      if (key===todayKey) hd.classList.add('is-today');

      const count = (jobsByDate[key]||[]).length;
      if (count){
        const badge = document.createElement('span');
        badge.className = 'cnt';
        badge.textContent = count;
        hd.appendChild(badge);
      }
      cell.appendChild(hd);

      // ===== show ALL jobs for the day (scroll if overflow) =====
      const wrap = document.createElement('div');
      wrap.className = 'evwrap';
      cell.appendChild(wrap);

      (jobsByDate[key] || []).forEach(j=>{
        const ev = document.createElement('a');
        ev.href = 'javascript:void(0)';
        ev.className = 'event';
        ev.style.setProperty('--bar', guessColor(j.status));
        ev.innerHTML = `<b>${(j.job_no||j.code||j.no||'').toString()}</b> <span>${j.title||''}</span>`;
        ev.title = `${j.title||''}\n${j.assignee||j.owner||''} · ${j.status||''}`;
        ev.addEventListener('click', ()=>{
          const rows = `
            <div class="kv"><span>Job No</span><b>${(j.job_no||j.code||j.no||'-')}</b></div>
            <div class="kv"><span>Title</span><b>${(j.title||'-')}</b></div>
            <div class="kv"><span>Owner</span><b>${(j.assignee||j.owner||'-')}</b></div>
            <div class="kv"><span>Status</span><b>${(j.status||'-')}</b></div>
            <div class="kv"><span>Project</span><b>${(j.project_id||'-')}</b></div>
            <div class="kv"><span>Date</span><b>${key}</b></div>
          `;
          openDrawer('Event details', `Date ${key}`, rows);
        });
        wrap.appendChild(ev);
      });

      // click empty → day agenda
      cell.addEventListener('click', (e)=>{
        if (e.target.closest('.event')) return;
        const items = (jobsByDate[key]||[]).map(x=>`
          <div class="li">
            <span class="cap" style="background:${guessColor(x.status)}"></span>
            <b>${x.job_no||x.code||x.no||''}</b> — ${x.title||''}
            <div class="sub">${(x.assignee||x.owner||'-')} · ${x.status||''}</div>
          </div>`).join('');
        openDrawer(`Agenda — ${key}`, 'All events/tasks', `<div class="list">${items||'<i>No events</i>'}</div>`);
      });

      monthGrid.appendChild(cell);
    }

    // sync mini selected
    document.querySelectorAll('.mini-cell').forEach(btn=>{
      btn.classList.toggle('active', btn.dataset.date===toKey(d));
    });
  }

  // ===== Navs & Shortcuts =====
  const plusMonthSet = n => { viewDate = plusMonth(viewDate, n); renderMini(viewDate); renderMain(viewDate); };
  miniPrev.addEventListener('click', ()=> plusMonthSet(-1));
  miniNext.addEventListener('click', ()=> plusMonthSet(+1));
  mainPrev.addEventListener('click', ()=> plusMonthSet(-1));
  mainNext.addEventListener('click', ()=> plusMonthSet(+1));
  btnToday.addEventListener('click', ()=>{ viewDate = new Date(); renderMini(viewDate); renderMain(viewDate); });

  // keyboard: ←/→ เดือนก่อน/ถัดไป, T = Today
  document.addEventListener('keydown', (e)=>{
    if (e.key==='ArrowLeft') plusMonthSet(-1);
    if (e.key==='ArrowRight') plusMonthSet(+1);
    if (e.key.toLowerCase()==='t') { viewDate=new Date(); renderMini(viewDate); renderMain(viewDate); }
  });

  // init
  renderTop(); renderMini(viewDate); renderMain(viewDate);
})();
</script>



<style>
/* ===================== White Calendar (Aurora-like) ===================== */
/* ===================== White Calendar (Polished) ===================== */
:root{
  --bg:#f6f8fb;
  --card:#ffffff;
  --ink:#0f172a;
  --muted:#64748b;
  --line:#e6eaf0;
  --primary:#0ea5e9;

  --ok:#16a34a; --info:#2563eb; --warn:#f59e0b; --hold:#6b7280; --blk:#ef4444; --vio:#8b5cf6;
}

*{ box-sizing:border-box; }
html,body{ height:100%; }
body{
  margin:0; background:var(--bg); color:var(--ink);
  font:14px/1.55 system-ui,-apple-system,"Segoe UI",Roboto,"Noto Sans Thai",sans-serif;
}

/* card base */
.card{
  background:var(--card); border:1px solid var(--line); border-radius:14px;
  box-shadow:0 1px 1px rgba(16,24,40,.02);
}

/* wrapper */
.calwrap.light{ min-height:100vh; display:flex; flex-direction:column; }

/* ---------- Topbar ---------- */
.cal-topbar{
  position:sticky; top:0; z-index:10;
  display:flex; align-items:center; justify-content:space-between; gap:16px;
  padding:12px 16px; background:rgba(255,255,255,.9); backdrop-filter:blur(8px);
  border-bottom:1px solid var(--line);
}
.cal-topbar .left{ display:flex; align-items:center; gap:8px; }
.cal-topbar .today-label{ font-weight:800; }

.btn{
  padding:10px 12px; border-radius:10px; border:1px solid var(--line);
  background:#fff; color:var(--ink); cursor:pointer; transition:box-shadow .12s ease, transform .06s ease;
}
.btn:hover{ box-shadow:0 4px 12px rgba(2,6,23,.08); transform:translateY(-1px); }
.btn.primary{ background:var(--primary); color:#fff; border-color:transparent; font-weight:800; }
.btn.ghost{ background:#fff; }
.btn.tiny{ padding:6px 10px; font-size:12px; border-radius:999px; }

.view-switch .seg{
  border:1px solid var(--line); border-radius:10px; background:#fff; padding:8px 12px; cursor:pointer;
}
.view-switch .seg.active{ background:var(--primary); color:#fff; border-color:transparent; }

/* ---------- Layout ---------- */
.cal-body{
  display:grid; grid-template-columns: 320px 1fr; gap:16px;
  padding:16px;
}
@media (max-width: 1024px){ .cal-body{ grid-template-columns:1fr; } }

/* ---------- Sidebar ---------- */
.side{ display:flex; flex-direction:column; gap:16px; position:sticky; top:64px; align-self:start; }
.mini{ padding:12px; }
.mini-head{ display:flex; align-items:center; justify-content:space-between; gap:8px; margin-bottom:10px; }
.mini-title{ font-weight:900; }
.nav{ border:1px solid var(--line); background:#fff; border-radius:8px; padding:6px 10px; cursor:pointer; }
.nav:hover{ box-shadow:0 3px 8px rgba(2,6,23,.08); }

.mini-grid{ display:grid; grid-template-columns: repeat(7, 1fr); gap:6px; }
.mini-dow{ text-align:center; font-size:12px; color:#475569; padding:2px 0; font-weight:700; }
.mini-cell{
  display:flex; align-items:center; justify-content:center; gap:6px;
  border:1px solid var(--line); background:#fff; border-radius:10px; padding:6px 0; cursor:pointer;
}
.mini-cell.dim{ opacity:.45; }
.mini-cell.today{ outline:2px solid var(--primary); outline-offset:2px; }
.mini-cell.active{ background:#e6f6fe; border-color:#cfefff; }
.mini-cell.has .dot{ width:6px; height:6px; background:var(--primary); border-radius:999px; display:inline-block; }

.legend{ padding:12px; }
.lg-title{ font-weight:900; margin-bottom:8px; }
.lg-list{ display:grid; grid-template-columns: repeat(2,minmax(0,1fr)); gap:6px 12px; font-size:12.5px; color:#334155; }
.legend .dot{ width:10px; height:10px; border-radius:999px; display:inline-block; margin-right:6px; vertical-align:middle; }
.legend .completed{ background:var(--ok); } .legend .inprogress{ background:var(--info); }
.legend .planned{ background:var(--warn); } .legend .onhold{ background:var(--hold); }
.legend .blocked{ background:var(--blk); } .legend .other{ background:var(--vio); }

.filters{ padding:12px; }
.f-head{ font-weight:900; margin-bottom:8px; }
.switch{ display:flex; align-items:center; gap:8px; margin:8px 0; }
.switch input{ display:none; }
.switch span{ width:34px; height:20px; border-radius:999px; background:#e5e7eb; position:relative; }
.switch span::after{ content:''; position:absolute; width:16px; height:16px; border-radius:999px; left:2px; top:2px; background:#fff; transition:.18s; box-shadow:0 1px 2px rgba(0,0,0,.12); }
.switch input:checked + span{ background:#d1f1fe; }
.switch input:checked + span::after{ transform:translateX(14px); background:#0ea5e9; }
.switch em{ color:#475569; font-style:normal; }

.field{ display:flex; flex-direction:column; gap:6px; margin-top:8px; }
.field .label{ font-size:12px; color:#475569; }
.field select, .field input{
  border:1px solid var(--line); border-radius:10px; background:#fff; padding:10px 12px; color:var(--ink);
}

/* ---------- Month View ---------- */
.month{ display:flex; flex-direction:column; gap:16px; }
.m-head{ display:flex; align-items:center; justify-content:space-between; padding:10px 12px; }
.m-head .title{ font-weight:900; font-size:18px; }

/* ทำหัวตารางกับช่องวันตรงคอลัมน์ */
.grid{
  padding:10px;
  display:grid;
  grid-template-columns: repeat(7, 1fr);
  grid-auto-rows:auto;
  gap:6px;
}
.grid .dow{
  text-align:center; color:#475569; font-size:12px; font-weight:700;
  padding:8px 0; border-bottom:1px solid var(--line);
}
.cells{
  grid-column:1 / -1;
  display:grid;
  grid-template-columns: repeat(7, 1fr);
  gap:6px;
  padding-top:0;
}

/* ภายในแต่ละวัน: โชว์งานทั้งหมดและเลื่อนในช่องได้ */
.day{ display:flex; flex-direction:column; gap:6px; min-width:0; aspect-ratio:1; }
@media (min-width:1280px){ .day{ aspect-ratio:1.1; } }
@media (max-width:820px){ .day{ aspect-ratio:.9; } }

.evwrap{
  display:flex; flex-direction:column; gap:6px;
  flex:1;               /* ใช้พื้นที่ที่เหลือจากหัววัน */
  min-height:0;         /* ให้ย่อได้ */
  overflow:auto;        /* มีหลายงาน ก็เลื่อนในช่อง */
  padding-bottom:2px;
}
/* สกอลล์บาร์บาง */
.evwrap::-webkit-scrollbar{ width:6px; }
.evwrap::-webkit-scrollbar-thumb{ background:#e2e8f0; border-radius:6px; }
.evwrap::-webkit-scrollbar-track{ background:transparent; }

.dnum{
  position:relative; display:flex; align-items:center; gap:6px; justify-content:space-between;
  font-weight:700;
}
.dnum.is-today{ color:#0b2038; }
.dnum .cnt{
  margin-left:auto; font-size:11px; padding:2px 6px; border-radius:999px;
  border:1px solid #dbe7ff; background:#eef5ff; color:#0b2d6b;
}

/* tile งานแบบคอมแพ็ค */
.event{
  display:flex; align-items:center; gap:6px;
  padding:6px 8px; background:#f8fafc; border:1px solid var(--line);
  border-radius:10px; text-decoration:none; line-height:1.25;
  border-left:6px solid var(--line);
  transition:box-shadow .12s ease, transform .06s ease;
}
.event{ border-left-color: var(--bar, var(--primary)); }
.event:hover{ box-shadow:0 6px 18px rgba(2,6,23,.06); transform:translateY(-1px); }
.event b{ font-weight:800; font-size:12px; }
.event span{ color:#334155; white-space:nowrap; overflow:hidden; text-overflow:ellipsis; }

/* more button */
.more{
  align-self:flex-start; margin-top:auto;
  background:#fff; border:1px dashed var(--line); color:#0b2038;
  padding:4px 8px; border-radius:999px; cursor:pointer; font-size:12px;
}

/* ---------- Drawer ---------- */
.drawer{
  position:fixed; inset:0; background:rgba(0,0,0,.35);
  display:none; align-items:stretch; justify-content:flex-end; z-index:40;
}
.drawer.open{ display:flex; }
.drawer-panel{ width:min(440px, 92vw); background:#fff; border-left:1px solid var(--line); display:flex; flex-direction:column; }
.drawer-head{ display:flex; align-items:flex-start; justify-content:space-between; gap:12px; padding:16px; border-bottom:1px solid var(--line); }
.drawer-title{ font-weight:900; }
.drawer-sub{ color:#64748b; font-size:12.5px; margin-top:2px; }
.drawer-body{ padding:16px; display:flex; flex-direction:column; gap:10px; max-height:calc(100vh - 160px); overflow:auto; }
.drawer-foot{ padding:14px 16px; border-top:1px solid var(--line); display:flex; gap:8px; justify-content:flex-end; }

.kv{ display:flex; align-items:center; justify-content:space-between; gap:10px; padding:10px 0; border-bottom:1px dashed var(--line); }
.list .li{ display:flex; align-items:flex-start; gap:10px; padding:8px 0; border-bottom:1px solid #f1f5f9; }
.list .li .cap{ width:10px; height:10px; border-radius:999px; margin-top:6px; }
.list .li .sub{ color:#64748b; font-size:12px; }

</style>
