<?php if (!can_admin()) { echo '<p>ต้องเป็นผู้ดูแลระบบ</p>'; return; }
$teams = $seed['teams'] ?? []; $users = $seed['users'] ?? [];
?>
<section class="section">
  <div class="section-head"><h2>ผู้ใช้</h2><button class="btn primary" onclick="openUserModal()">+ ผู้ใช้ใหม่</button></div>
  <div class="table">
    <div class="t-row t-head"><div>ชื่อ</div><div>Email</div><div>บทบาท</div><div>ทีม</div><div>จัดการ</div></div>
    <?php foreach ($users as $u): ?>
    <div class="t-row">
      <div><?= htmlspecialchars($u['name']) ?></div>
      <div><?= htmlspecialchars($u['email']) ?></div>
      <div><span class="badge role"><?= htmlspecialchars($u['role']) ?></span></div>
      <div><?= htmlspecialchars($u['team']) ?></div>
      <div><button class="btn tiny" onclick="editUserMock(<?= (int)$u['id'] ?>)">แก้ไข</button> <button class="btn tiny danger" onclick="deleteUserMock(<?= (int)$u['id'] ?>)">ลบ</button></div>
    </div>
    <?php endforeach; ?>
  </div>
</section>
<div id="user-modal" class="modal hidden">
  <div class="modal-card">
    <div class="modal-head">ผู้ใช้</div>
    <div class="modal-body grid">
      <label>ชื่อ <input id="u-name"></label>
      <label>Email <input id="u-email" type="email"></label>
      <label>บทบาท
        <select id="u-role">
          <option value="admin">admin</option><option value="view_all">view_all</option>
          <option value="view_group" selected>view_group</option><option value="planner">planner</option>
        </select>
      </label>
      <label>ทีม <select id="u-team"><?php foreach ($teams as $t): ?><option><?= htmlspecialchars($t) ?></option><?php endforeach; ?></select></label>
    </div>
    <div class="modal-foot"><button class="btn" onclick="closeUserModal()">ยกเลิก</button><button class="btn primary" onclick="saveUserMock()">บันทึก (Mock)</button></div>
  </div>
</div>
