<?php
session_start();
require_once __DIR__ . '/../lib/router.php';
require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/permissions.php';
require_once __DIR__ . '/../lib/storage.php';
if (!isset($_SESSION['user'])) {
  $_SESSION['user'] = ['id'=>3,'name'=>'Viewer (Group Main)','email'=>'viewer@demo.local','role'=>'view_group','team'=>'Production'];
}
$route = route_path();
$routes = [
  '/'             => ['dashboard/index.php', 'Dashboard'],
  '/login'        => ['auth/login.php', 'Login', function(){ return true; }],
  '/logout'       => [null, 'Logout', function(){ logout(); header('Location: /login'); return false; }],
  '/projects'     => ['projects/list.php', 'Projects'],
  '/project'      => ['projects/detail.php', 'Project Detail'],
  '/calendar'     => ['calendar/index.php', 'Calendar'],
  '/admin/users'  => ['admin/users.php',  'User Management',  function(){ return can_admin(); }],
  '/admin/teams'  => ['admin/teams.php',  'Teams',            function(){ return can_admin(); }],
];
list($viewFile, $title) = resolve_route($route, $routes);
$guard = $routes[$route][2] ?? function(){ return is_logged_in(); };
if (!$guard()) { header('Location: /login'); exit; }
$seed = storage_read(); $user = current_user();
include __DIR__ . '/../views/layout.php';
